# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 8
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR8_strategy.txt
# LLM Suggested Fallback: C

def celestial_harmony(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Early rounds (1-3): Establish goodwill
    if current_round <= 3:
        if current_round == 1:
            return "C"
        if opp_history[-1] == "D":
            return "D"
        return "C"
    
    # Mid rounds (4-7): Tit-for-tat with forgiveness
    if current_round <= 7:
        if opp_history[-1] == "C":
            return "C"
        else:
            if "forgiveness" in opponent_program_code.lower() or "random" in opponent_program_code.lower():
                return "D" if random.random() < 0.9 else "C"
            return "D" if random.random() < 0.8 else "C"
    
    # Late rounds (8-10): Maximize payoff
    if sum(1 for move in opp_history if move == "D") >= 3:
        return "D"
    if current_round == total_rounds:
        return "D"
    if opp_history[-1] == "C":
        return "C"
    return "D"